/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.api;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.activity.Activity;
import de.jcm.discordgamesdk.activity.ActivityButton;
import de.jcm.discordgamesdk.activity.ActivityButtonsMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.HOMecRaftfPycZ;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.hOMecRAFTN0DyG;
import pro.gravit.launcher.hOmecRAftUDctB;
import pro.gravit.launcher.hoMEcraFTq8prW;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class DiscordActivityService {
    private final Map<String, String> params = new ConcurrentHashMap<String, String>();
    private String details;
    private String state;
    private String largeKey;
    private String smallKey;
    private String largeText;
    private String smallText;
    private String partyId;
    private int partySize;
    private int partyMaxSize;
    private final List<ActivityButton> buttons = new ArrayList<ActivityButton>(2);

    public DiscordActivityService() {
        this.setParam("launcherVersion", Version.getVersion().getVersionString());
        this.setParam("javaVersion", Integer.toString(JVMHelper.JVM_VERSION));
        this.setParam("javaBits", Integer.toString(JVMHelper.JVM_BITS));
        this.setParam("os", JVMHelper.OS_TYPE.name);
    }

    public void applyToActivity(Activity activity) {
        if (this.details != null) {
            activity.setDetails(this.details);
        }
        if (this.state != null) {
            activity.setState(this.state);
        }
        if (this.largeKey != null) {
            activity.assets().setLargeImage(this.largeKey);
        }
        if (this.smallKey != null) {
            activity.assets().setSmallImage(this.smallKey);
        }
        if (this.smallText != null) {
            activity.assets().setSmallText(this.smallText);
        }
        if (this.largeText != null) {
            activity.assets().setLargeText(this.largeText);
        }
        if (this.partyId != null) {
            activity.party().setID(this.partyId);
        }
        if (this.partyMaxSize != 0) {
            activity.party().size().setCurrentSize(this.partySize);
            activity.party().size().setMaxSize(this.partyMaxSize);
        }
        if (!this.buttons.isEmpty()) {
            activity.setActivityButtonsMode(ActivityButtonsMode.BUTTONS);
            ArrayList<ActivityButton> arrayList = new ArrayList<ActivityButton>(activity.getButtons());
            for (ActivityButton activityButton : arrayList) {
                activity.removeButton(activityButton);
            }
            for (ActivityButton activityButton : this.buttons) {
                activity.addButton(activityButton);
            }
        }
    }

    public void updateActivity() {
        Core core = HOMecRaftfPycZ.HomeCRaFt65w0u();
        if (core == null) {
            return;
        }
        this.applyToActivity(HOMecRaftfPycZ.hOMEcraFT2ESEM());
        core.activityManager().updateActivity(HOMecRaftfPycZ.hOMEcraFT2ESEM());
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String string) {
        this.details = this.replaceParams(string);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = this.replaceParams(string);
    }

    public String getLargeKey() {
        return this.largeKey;
    }

    public void setLargeKey(String string) {
        this.largeKey = this.replaceParams(string);
    }

    public String getSmallKey() {
        return this.smallKey;
    }

    public void setSmallKey(String string) {
        this.smallKey = this.replaceParams(string);
    }

    public String getLargeText() {
        return this.largeText;
    }

    public void setLargeText(String string) {
        this.largeText = this.replaceParams(string);
    }

    public String getSmallText() {
        return this.smallText;
    }

    public void setSmallText(String string) {
        this.smallText = this.replaceParams(string);
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String string) {
        this.partyId = this.replaceParams(string);
        this.updateActivity();
    }

    public int getPartySize() {
        return this.partySize;
    }

    public void setPartySize(int n) {
        this.partySize = n;
        this.updateActivity();
    }

    public int getPartyMaxSize() {
        return this.partyMaxSize;
    }

    public void setPartyMaxSize(int n) {
        this.partyMaxSize = n;
        this.updateActivity();
    }

    public void setParam(String string, String string2) {
        String string3 = this.params.put(string, string2);
        if (string3 != null) {
            this.updateActivity();
        }
    }

    public void addButton(ActivityButton activityButton) {
        this.buttons.add(activityButton);
    }

    public void clearButtons() {
        this.buttons.clear();
    }

    public String getParam(String string) {
        return this.params.get(string);
    }

    public Map<String, String> getUnmodifiableParamsMap() {
        return Collections.unmodifiableMap(this.params);
    }

    public String replaceParams(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (entry.getValue() == null) {
                LogHelper.warning("DiscordGame: Param %s null", entry.getKey());
                continue;
            }
            string2 = string2.replaceAll("%" + entry.getKey() + "%", entry.getValue());
        }
        return string2;
    }

    public void updateLoginStage() {
        this.setParam("username", "");
        this.setParam("uuid", "");
        this.setScope(hoMEcraFTq8prW.HOmeCRaFtFbHNa);
    }

    public void updateAuthorizedStage(PlayerProfile playerProfile) {
        this.onPlayerProfile(playerProfile);
        this.setScope(hoMEcraFTq8prW.HOmeCRAft2JTkH);
    }

    public void updateClientStage(hOMecRAFTN0DyG hOMecRAFTN0DyG2) {
        this.setParam("profileVersion", hOMecRAFTN0DyG2.HOmeCRaFtFbHNa.getVersion().toString());
        this.setParam("profileName", hOMecRAFTN0DyG2.HOmeCRaFtFbHNa.getTitle());
        this.setParam("profileUUID", hOMecRAFTN0DyG2.HOmeCRaFtFbHNa.getUUID().toString());
        this.setParam("profileHash", hOMecRAFTN0DyG2.HOmeCRaFtFbHNa.getUUID().toString().replaceAll("-", ""));
        this.onPlayerProfile(hOMecRAFTN0DyG2.HomecrAFtTvvXM);
        this.setScope(hoMEcraFTq8prW.homeCrafTzK1E1);
    }

    public void onPlayerProfile(PlayerProfile playerProfile) {
        this.setParam("username", playerProfile.username);
        this.setParam("uuid", playerProfile.uuid.toString());
        if (playerProfile.assets.get("AVATAR") != null) {
            this.setParam("avatarUrl", playerProfile.assets.get((Object)"AVATAR").url);
        }
    }

    private void setScope(hOmecRAftUDctB hOmecRAftUDctB2) {
        LogHelper.dev(hOmecRAftUDctB2.toString());
        this.setDetails(hOmecRAftUDctB2.HomeCRaFt65w0u());
        this.setState(hOmecRAftUDctB2.hOMEcraFT2ESEM());
        this.setLargeKey(hOmecRAftUDctB2.homeCRaFTm7qS8());
        this.setLargeText(hOmecRAftUDctB2.hOmecRaftBJhL6());
        this.setSmallKey(hOmecRAftUDctB2.HomECrAFTzc6Ff());
        this.setSmallText(hOmecRAftUDctB2.HomecrAFtTvvXM());
        this.clearButtons();
        if (hOmecRAftUDctB2.HOmeCRaFtFbHNa()) {
            this.addButton(new ActivityButton(hOmecRAftUDctB2.HOmeCRAft2JTkH(), hOmecRAftUDctB2.homeCrafTzK1E1()));
        }
        if (hOmecRAftUDctB2.HomecraFTvfwkg()) {
            this.addButton(new ActivityButton(hOmecRAftUDctB2.HoMECRAfTNpVpE(), hOmecRAftUDctB2.HOMecRAFtZS7jp()));
        }
        this.updateActivity();
    }

    public void resetStartTime() {
        HOMecRaftfPycZ.hOMEcraFT2ESEM().timestamps().setStart(Instant.now());
    }
}

